﻿IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_ImportRespondentResponse]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].Sp_ImportRespondentResponse
GO


CREATE  PROCEDURE [dbo].[Sp_ImportRespondentResponse]
	@ProjectId     INT,
	@UserId        INT,
	@CollectMode   INT,
	@RpsRespondent VARCHAR(10),
	@RpsQuestion   VARCHAR(32),
	@RpsMatrix     BIGINT,
	@RpsMention    INT,
	@RpsContent    NVARCHAR(100),
	@rpsOpened     NTEXT,
	@rpsType       INT,
	@CallId        INT,
	@Source        nvarchar(max),
	@newRespondent bit  = 0,
	@Modified      datetime = null,
	@QuestionOrder INT = null,
	@ChoiceOrder   INT = null

AS
IF @Modified is null SET @Modified = GETUTCDATE();


IF ( @newRespondent = 1 )
	BEGIN
		-- Since we are sure that's a new respondent, we go for an insert directly for performance optimization but we will still be safe with this "Insdate" method. Should fall in the catch very rarely
		BEGIN TRY
			INSERT INTO Response 
				(RpsRespondent, ProjectId,  CollectMode, modifiedby,  modified, RpsQuestion,  RpsMatrix,  RpsMention, RpsContent,  RpsOpened,  RpsType,  CallId,  [Source], QuestionOrder,  ChoiceOrder)
			VALUES
				(@RpsRespondent, @ProjectId,@CollectMode,@UserId,@Modified, @RpsQuestion,@RpsMatrix,@RpsMention,@RpsContent,@rpsOpened, @rpsType,@CallId, @Source,@QuestionOrder, @ChoiceOrder)
		END TRY
		BEGIN CATCH
			IF ERROR_NUMBER() = 2627  --2627 is a primary key violation
				BEGIN
					-- Using UpSert command method for fall-back
					UPDATE Response
					SET	ProjectId = @ProjectId,
							CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
							modifiedby = @UserId,
							modified = @Modified,
							RpsContent = @RpsContent,
							RpsOpened = @RpsOpened,
							CallId = @CallId,
							[Source] = @Source,
							QuestionOrder = @QuestionOrder,
							ChoiceOrder = @ChoiceOrder
					WHERE  
							RpsRespondent = @RpsRespondent
							AND RpsQuestion = @RpsQuestion
							AND RpsMatrix = @RpsMatrix
							AND RpsMention = @RpsMention
							AND RpsType = @RpsType
				END
		END CATCH
	END
ELSE
	BEGIN
			-- Using UpSert command method for safety
			UPDATE Response
			SET	ProjectId = @ProjectId,
					CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
					modifiedby = @UserId,
					modified = @Modified,
					RpsContent = @RpsContent,
					RpsOpened = @RpsOpened,
					CallId = @CallId,
					[Source] = @Source,
					QuestionOrder = @QuestionOrder,
					ChoiceOrder = @ChoiceOrder
			WHERE  
					RpsRespondent = @RpsRespondent
					AND RpsQuestion = @RpsQuestion
					AND RpsMatrix = @RpsMatrix
					AND RpsMention = @RpsMention
					AND RpsType = @RpsType
		
			IF @@ROWCOUNT = 0
			BEGIN
				INSERT INTO Response 
					(RpsRespondent, ProjectId,  CollectMode, modifiedby,  modified, RpsQuestion,  RpsMatrix,  RpsMention, RpsContent,  RpsOpened,  RpsType,  CallId,  [Source], QuestionOrder,  ChoiceOrder)
				VALUES
					(@RpsRespondent, @ProjectId,@CollectMode,@UserId,@Modified, @RpsQuestion,@RpsMatrix,@RpsMention,@RpsContent,@rpsOpened, @rpsType,@CallId, @Source,@QuestionOrder, @ChoiceOrder)
			END
	END
GO